/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.OSPFv6LinkStateRequestPacket;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6PacketImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFv6LinkStateRequestPacketImpl
extends OSPFv6PacketImpl
implements OSPFv6LinkStateRequestPacket {
    protected Short LSType;
    protected int linkStateId;
    protected List<IPAddress> advertisingRouters;

    public OSPFv6LinkStateRequestPacketImpl() {
        this.fieldNames.add("OSPFv6LinkStateRequestPacketImpl_LSType");
        this.fieldNames.add("OSPFv6LinkStateRequestPacketImpl_linkStateId");
        this.fieldNames.add("OSPFv6LinkStateRequestPacketImpl_advertisingRouters");
        this.signalType = "Ospfv6LinkStateRequestPacket";
    }

    @Override
    public Short getLSType() {
        return this.LSType;
    }

    @Override
    public void setLSType(Short LSType) {
        this.LSType = LSType;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6LinkStateRequestPacketImpl_LSType")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("OSPFv6LinkStateRequestPacketImpl_LSType", LSType));
            return;
        }
    }

    @Override
    public int getLinkStateId() {
        return this.linkStateId;
    }

    @Override
    public void setLinkStateId(int linkStateId) {
        this.linkStateId = linkStateId;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6LinkStateRequestPacketImpl_linkStateId")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("OSPFv6LinkStateRequestPacketImpl_linkStateId", linkStateId));
            return;
        }
    }

    @Override
    public List<IPAddress> getAdvertisingRouters() {
        return this.advertisingRouters;
    }

    @Override
    public void setAdvertisingRouters(List<IPAddress> advertisingRouters) {
        this.advertisingRouters = advertisingRouters;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6LinkStateRequestPacketImpl_advertisingRouters")) continue;
            this.fieldTable.set(i, new Pair<String, List<IPAddress>>("OSPFv6LinkStateRequestPacketImpl_advertisingRouters", advertisingRouters));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("OSPFv6LinkStateRequestPacketImpl_LSType")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("OSPFv6LinkStateRequestPacketImpl_linkStateId")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("OSPFv6LinkStateRequestPacketImpl_advertisingRouters")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Short>("OSPFv6LinkStateRequestPacketImpl_LSType", this.LSType));
        this.fieldTable.add(new Pair<String, Integer>("OSPFv6LinkStateRequestPacketImpl_linkStateId", this.linkStateId));
        this.fieldTable.add(new Pair<String, List<IPAddress>>("OSPFv6LinkStateRequestPacketImpl_advertisingRouters", this.advertisingRouters));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.LSType = this.readShort(buffer);
        this.linkStateId = this.readInt(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.advertisingRouters = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.advertisingRouters.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.LSType = this.pduReadShort(buffer);
        this.linkStateId = this.pduReadInt(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)10);
        this.advertisingRouters = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.advertisingRouters.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putShort(this.LSType);
        buffer.putInt(this.linkStateId);
        buffer.putInt(this.advertisingRouters.size());
        for (IPAddress item : this.advertisingRouters) {
            buffer.putIPAddress(item);
        }
    }
}

